var encoder = require('../../encoder_tt_rev-4');

// protocol v4

var ttDevice = {
  "config_update_req": {
    "config_type": "base",
    "protocol_version": 4,
    "tag": "0x096c4970",
    "payload": {
      "switch_mask": {
        "enable_confirmed_event_message": false,
        "enable_confirmed_data_message": false,
        "allow_deactivation": true
      },
      "periodic_message_random_delay_seconds": 31,
      "status_message_interval": "5 days",
    }
  }
};

var tt_SensorOfficial = {
  "config_update_req": {
    "config_type": "sensor",
    "protocol_version": 4,
    "tag": "0xE85892DC",
    "payload": {
      "device_type": "tt",
      "sensor_type": "K",
      'switch_mask': { 'selection': "avg_only" },
      'measurement_interval_minutes': 5,
      "periodic_event_message_interval": 12
    }
  }
};

function encode(tag, object) {
  console.log("#### " + tag)
  console.log("JSON:")
  console.log("```")
  console.log(JSON.stringify(object, null, 4))
  console.log("```")
  bytestring = Buffer.from(encoder.encodeDownlink({data: object}).bytes)
  console.log("Bytestring (hexidecimal):")
  console.log("```")
  console.log(bytestring.toString('hex'))
  console.log("```")
}

console.log("")
console.log("### Encoding TT protocol v4")
console.log("")
console.log("Generated by:")
console.log("```")
console.log("nodejs ./examples/" + __filename.split('/').slice(-1)[0])
console.log("```")
console.log("")
encode("Base config message", ttDevice);
encode("Sensor config message", tt_SensorOfficial);
